EESchema Schematic File Version 4
LIBS:tehtnica-v4-usb-c-nRF_Low_Power-cache
EELAYER 29 0
EELAYER END
$Descr A3 16535 11693
encoding utf-8
Sheet 1 1
Title "Tehtnica v4 (USB Type-C connector) nRF52832 chip low VDD"
Date "2019-03-28"
Rev "1.0.1"
Comp "Jozef Stefan Institute"
Comment1 "Computer Systems Department"
Comment2 ""
Comment3 ""
Comment4 ""
$EndDescr
Wire Wire Line
	15375 1450 15375 1625
Wire Wire Line
	15575 1775 15575 2250
Wire Wire Line
	15175 1775 14725 1775
$Comp
L Jumper:SolderJumper_3_Bridged12 JP1
U 1 1 5E786B66
P 15375 1775
F 0 "JP1" H 15525 1675 50  0000 C CNN
F 1 "Jumper" H 15375 1875 50  0000 C CNN
F 2 "" H 15375 1775 50  0001 C CNN
F 3 "~" H 15375 1775 50  0001 C CNN
	1    15375 1775
	1    0    0    1   
$EndComp
Wire Wire Line
	15525 2250 15575 2250
Connection ~ 14725 1775
Wire Wire Line
	15000 2250 15000 2650
Connection ~ 15000 2250
Wire Wire Line
	15125 2250 15000 2250
Wire Wire Line
	15000 2650 15000 2875
Connection ~ 15000 2650
Wire Wire Line
	15025 2650 15000 2650
Wire Wire Line
	15325 2650 15325 2550
Connection ~ 15325 2650
Wire Wire Line
	15325 2750 15325 2650
Connection ~ 15000 3275
Wire Wire Line
	15325 3275 15325 3150
Wire Wire Line
	15000 3275 15325 3275
$Comp
L Device:R R31
U 1 1 5DBB7B1E
P 15175 2650
F 0 "R31" V 15075 2650 50  0000 C CNN
F 1 "10M" V 15275 2650 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 15105 2650 50  0001 C CNN
F 3 "~" H 15175 2650 50  0001 C CNN
	1    15175 2650
	0    1    1    0   
$EndComp
$Comp
L Transistor_FET:BSS138 Q32
U 1 1 5DB78F8D
P 15425 2950
F 0 "Q32" H 15275 3100 50  0000 L CNN
F 1 "BSS138" H 15150 2800 50  0000 L CNN
F 2 "Package_TO_SOT_SMD:SOT-23" H 15625 2875 50  0001 L CIN
F 3 "https://www.fairchildsemi.com/datasheets/BS/BSS138.pdf" H 15425 2950 50  0001 L CNN
	1    15425 2950
	-1   0    0    -1  
$EndComp
Wire Wire Line
	9400 2375 9700 2375
Wire Wire Line
	9400 1475 9700 1475
Connection ~ 9700 2375
Wire Wire Line
	9700 1475 10500 1475
Connection ~ 9700 1475
$Comp
L Transistor_FET:BSS138 Q51
U 1 1 5BFC5009
P 9800 2125
F 0 "Q51" H 9700 2275 50  0000 L CNN
F 1 "BSS138" H 9550 1925 50  0000 L CNN
F 2 "Package_TO_SOT_SMD:SOT-23" H 10000 2050 50  0001 L CIN
F 3 "https://www.fairchildsemi.com/datasheets/BS/BSS138.pdf" H 9800 2125 50  0001 L CNN
	1    9800 2125
	-1   0    0    -1  
$EndComp
Wire Wire Line
	9700 1825 9700 1925
Text GLabel 15625 2950 2    50   Input ~ 0
APower
Wire Wire Line
	15000 1475 15000 2250
Wire Wire Line
	14375 1475 15000 1475
Connection ~ 14725 3275
Wire Wire Line
	14725 3275 15000 3275
$Comp
L Transistor_FET:BSS83P Q31
U 1 1 5D7ADE6E
P 15325 2350
F 0 "Q31" V 15668 2350 50  0000 C CNN
F 1 "NX3008PBK" V 15577 2350 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23" H 15525 2275 50  0001 L CIN
F 3 "http://www.farnell.com/datasheets/1835997.pdf" H 15325 2350 50  0001 L CNN
	1    15325 2350
	0    1    -1   0   
$EndComp
Connection ~ 14375 1475
Connection ~ 14375 1775
Connection ~ 13675 3275
Wire Wire Line
	13675 3275 14725 3275
$Comp
L Device:C C8
U 1 1 5C1A450C
P 14725 3025
F 0 "C8" H 14750 3125 50  0000 L CNN
F 1 "2.2uF" H 14750 2925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 14763 2875 50  0001 C CNN
F 3 "~" H 14725 3025 50  0001 C CNN
	1    14725 3025
	1    0    0    -1  
$EndComp
Wire Wire Line
	14725 3275 14725 3175
$Comp
L power:VCC #PWR0108
U 1 1 5C0CF510
P 14725 1775
F 0 "#PWR0108" H 14725 1625 50  0001 C CNN
F 1 "VCC" H 14742 1948 50  0000 C CNN
F 2 "" H 14725 1775 50  0001 C CNN
F 3 "" H 14725 1775 50  0001 C CNN
	1    14725 1775
	1    0    0    -1  
$EndComp
Wire Wire Line
	14725 1775 14725 2875
Wire Wire Line
	14375 1775 14725 1775
$Comp
L Device:C C7
U 1 1 5C1A43BA
P 15000 3025
F 0 "C7" H 15025 3125 50  0000 L CNN
F 1 "10uF" H 15025 2925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 15038 2875 50  0001 C CNN
F 3 "~" H 15000 3025 50  0001 C CNN
	1    15000 3025
	1    0    0    -1  
$EndComp
$Comp
L power:VSS #PWR01
U 1 1 5CCE952F
P 15375 1450
F 0 "#PWR01" H 15375 1300 50  0001 C CNN
F 1 "VSS" H 15392 1623 50  0000 C CNN
F 2 "" H 15375 1450 50  0001 C CNN
F 3 "" H 15375 1450 50  0001 C CNN
	1    15375 1450
	1    0    0    -1  
$EndComp
Wire Wire Line
	15000 3175 15000 3275
Wire Wire Line
	11025 1475 12875 1475
Connection ~ 11025 1475
Connection ~ 10500 1475
Wire Wire Line
	10500 1475 11025 1475
Wire Wire Line
	10500 2375 9700 2375
Wire Wire Line
	10500 2325 10500 2375
Wire Wire Line
	10500 1625 10500 1475
Wire Wire Line
	10500 1975 10500 2025
Connection ~ 10500 1975
Wire Wire Line
	10600 1975 10500 1975
Wire Wire Line
	10500 1925 10500 1975
Text GLabel 10600 1975 2    50   Output ~ 0
POWER
$Comp
L Device:R R5
U 1 1 5CB053D7
P 10500 2175
F 0 "R5" H 10570 2221 50  0000 L CNN
F 1 "100k" H 10570 2130 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 10430 2175 50  0001 C CNN
F 3 "~" H 10500 2175 50  0001 C CNN
	1    10500 2175
	1    0    0    -1  
$EndComp
$Comp
L Device:R R4
U 1 1 5CB052A7
P 10500 1775
F 0 "R4" H 10570 1821 50  0000 L CNN
F 1 "51k" H 10570 1730 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 10430 1775 50  0001 C CNN
F 3 "~" H 10500 1775 50  0001 C CNN
	1    10500 1775
	1    0    0    -1  
$EndComp
Wire Wire Line
	11275 3275 11025 3275
Connection ~ 11275 3275
Wire Wire Line
	11275 3175 11275 3275
Wire Wire Line
	11025 2775 11025 1475
Connection ~ 11025 2775
Wire Wire Line
	11275 2775 11025 2775
Wire Wire Line
	11275 2875 11275 2775
Wire Wire Line
	11025 2875 11025 2775
Connection ~ 11675 3275
Wire Wire Line
	11025 3275 11025 3175
Wire Wire Line
	11675 3275 11275 3275
Wire Wire Line
	9700 2375 9700 2425
Connection ~ 9400 2375
Wire Wire Line
	9700 1475 9700 1525
Connection ~ 9400 1475
$Comp
L Device:C C3
U 1 1 5C9949BE
P 11025 3025
F 0 "C3" H 11050 3125 50  0000 L CNN
F 1 "10uF" H 11050 2925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 11063 2875 50  0001 C CNN
F 3 "~" H 11025 3025 50  0001 C CNN
	1    11025 3025
	1    0    0    -1  
$EndComp
Wire Wire Line
	9700 2325 9700 2375
Wire Wire Line
	9700 1425 9700 1475
Wire Wire Line
	14375 1975 14375 1775
Wire Wire Line
	14275 1975 14375 1975
Wire Wire Line
	14275 1775 14375 1775
Connection ~ 10150 4525
Wire Wire Line
	10450 4525 10150 4525
Wire Wire Line
	10450 4425 10450 4525
Connection ~ 10150 3625
Wire Wire Line
	10450 3625 10150 3625
Wire Wire Line
	10450 4125 10450 3625
Wire Wire Line
	9250 4525 9650 4525
Connection ~ 9250 4525
Wire Wire Line
	9250 4425 9250 4525
Wire Wire Line
	8900 3825 8900 3875
Connection ~ 8900 3825
Wire Wire Line
	8750 3825 8900 3825
Wire Wire Line
	8900 3775 8900 3825
Wire Wire Line
	9250 3825 9250 4125
Wire Wire Line
	8950 4025 9400 4025
Wire Wire Line
	8950 4525 9250 4525
Text Notes 12750 3250 0    50   ~ 0
>6V (0402)
Text Notes 12000 2425 0    50   ~ 0
>10V\n(0402)
Wire Wire Line
	6950 4025 7750 4025
Wire Wire Line
	7300 3925 7750 3925
Wire Wire Line
	7650 3825 7750 3825
Wire Wire Line
	7350 3725 7750 3725
Wire Wire Line
	7350 3325 7750 3325
Wire Wire Line
	7650 3225 7750 3225
Wire Wire Line
	7300 3125 7750 3125
Wire Wire Line
	6950 3025 7750 3025
Text Notes 12000 3925 0    50   ~ 0
Ali pa FET oz. \nsploh ne rabimo:\nfloating connection\n\n(Multicomp MSS3 - manjsi, \nalternativa:\nC&K JS102011SAQN)
Text GLabel 10000 2125 2    50   Input ~ 0
LOAD
Text GLabel 8750 3125 2    50   Input ~ 0
W_En2
Text GLabel 8750 3025 2    50   Input ~ 0
W_En1
Text GLabel 8750 2925 2    50   Output ~ 0
W_nCHG
Text GLabel 14275 2775 2    50   UnSpc ~ 0
Sink1
Text GLabel 14275 2675 2    50   UnSpc ~ 0
AMUX
Text GLabel 14275 2575 2    50   Output ~ 0
POkLDO
Text GLabel 14275 2475 2    50   Input ~ 0
PMLDO
Text GLabel 14275 2275 2    50   Output ~ 0
nIRQ
Text GLabel 14275 2175 2    50   Input ~ 0
SCL
Text GLabel 14275 2075 2    50   3State ~ 0
SDA
Text GLabel 14275 2875 2    50   UnSpc ~ 0
Sink2
Wire Wire Line
	14375 1625 14275 1625
Wire Wire Line
	14375 1475 14375 1625
Wire Wire Line
	14275 1475 14375 1475
$Comp
L Connector:TestPoint TP2
U 1 1 5C192685
P 11525 2475
F 0 "TP2" H 11325 2600 50  0000 L CNN
F 1 "TestPoint" H 11300 2425 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_2.0x2.0mm" H 11725 2475 50  0001 C CNN
F 3 "~" H 11725 2475 50  0001 C CNN
	1    11525 2475
	1    0    0    -1  
$EndComp
Connection ~ 12325 1875
Wire Wire Line
	12325 1725 12325 1875
Connection ~ 11675 1775
Wire Wire Line
	11675 1725 11675 1775
$Comp
L Connector:TestPoint TP3
U 1 1 5C181DCA
P 12325 1725
F 0 "TP3" H 12383 1845 50  0000 L CNN
F 1 "TestPoint" H 12383 1754 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_2.0x2.0mm" H 12525 1725 50  0001 C CNN
F 3 "~" H 12525 1725 50  0001 C CNN
	1    12325 1725
	1    0    0    -1  
$EndComp
$Comp
L Connector:TestPoint TP1
U 1 1 5C181AE9
P 11675 1725
F 0 "TP1" H 11733 1845 50  0000 L CNN
F 1 "TestPoint" H 11733 1754 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_2.0x2.0mm" H 11875 1725 50  0001 C CNN
F 3 "~" H 11875 1725 50  0001 C CNN
	1    11675 1725
	1    0    0    -1  
$EndComp
Wire Wire Line
	11525 2475 11675 2475
Connection ~ 11675 2475
Wire Wire Line
	11675 3275 11675 2475
Connection ~ 11975 1775
Wire Wire Line
	12875 1775 11975 1775
Connection ~ 12475 1875
Wire Wire Line
	12875 1875 12475 1875
Wire Wire Line
	12875 1975 12775 1975
Wire Wire Line
	11975 2475 12325 2475
Connection ~ 11975 2475
Wire Wire Line
	11975 2475 11975 2275
Wire Wire Line
	12325 2475 12325 2275
Wire Wire Line
	11675 2475 11975 2475
Wire Wire Line
	12325 3275 12725 3275
Connection ~ 12325 3275
Wire Wire Line
	12325 3175 12325 3275
Wire Wire Line
	12725 3275 13475 3275
Connection ~ 12725 3275
Wire Wire Line
	12725 3175 12725 3275
Wire Wire Line
	13475 3275 13675 3275
Connection ~ 13475 3275
Wire Wire Line
	13475 3125 13475 3275
Wire Wire Line
	13675 3275 13675 3125
Wire Wire Line
	11675 3275 12325 3275
Wire Wire Line
	11675 2275 11675 2475
Wire Wire Line
	12425 2675 12425 2775
Wire Wire Line
	12875 2675 12425 2675
Wire Wire Line
	12875 2875 12725 2875
Wire Wire Line
	12475 1975 12475 1875
Wire Wire Line
	12325 1875 12475 1875
Wire Wire Line
	12325 1975 12325 1875
Wire Wire Line
	11975 1775 11675 1775
Wire Wire Line
	11975 1975 11975 1775
Wire Wire Line
	11675 1775 11675 1975
$Comp
L Device:Battery_Cell BT1
U 1 1 5C0E5F52
P 11675 2175
F 0 "BT1" H 11525 2325 50  0000 L CNN
F 1 "Battery_Cell" H 11200 2150 50  0000 L CNN
F 2 "" V 11675 2235 50  0001 C CNN
F 3 "~" V 11675 2235 50  0001 C CNN
	1    11675 2175
	1    0    0    -1  
$EndComp
$Comp
L Device:C C5
U 1 1 5C0828DD
P 11975 2125
F 0 "C5" H 12000 2225 50  0000 L CNN
F 1 "4,7uF" H 12000 2025 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 12013 1975 50  0001 C CNN
F 3 "~" H 11975 2125 50  0001 C CNN
	1    11975 2125
	1    0    0    -1  
$EndComp
$Comp
L Device:Thermistor_NTC TH1
U 1 1 5C0AFE7B
P 12325 2125
F 0 "TH1" H 12175 2300 50  0000 L CNN
F 1 "Thermistor_NTC" H 12350 1975 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" H 12325 2175 50  0001 C CNN
F 3 "~" H 12325 2175 50  0001 C CNN
	1    12325 2125
	1    0    0    -1  
$EndComp
$Comp
L Device:R R6
U 1 1 5C0811EE
P 12625 1975
F 0 "R6" V 12725 1875 50  0000 C CNN
F 1 "10k" V 12725 2075 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 12555 1975 50  0001 C CNN
F 3 "~" H 12625 1975 50  0001 C CNN
	1    12625 1975
	0    1    1    0   
$EndComp
$Comp
L Device:C C6
U 1 1 5C080C49
P 12725 3025
F 0 "C6" H 12750 3125 50  0000 L CNN
F 1 "1uF" H 12750 2925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 12763 2875 50  0001 C CNN
F 3 "~" H 12725 3025 50  0001 C CNN
	1    12725 3025
	1    0    0    -1  
$EndComp
$Comp
L Switch:SW_SPDT SW1
U 1 1 5C080A6A
P 12325 2975
F 0 "SW1" V 12175 3175 50  0000 R CNN
F 1 "MSS3" V 12575 3225 50  0000 R CNN
F 2 "Button_Switch_SMD:SW_SPDT_PCM12" H 12325 2975 50  0001 C CNN
F 3 "" H 12325 2975 50  0001 C CNN
	1    12325 2975
	0    -1   -1   0   
$EndComp
$Comp
L Power.Management.IC:MAX77734_BGA U1
U 1 1 5C08056F
P 13575 2175
F 0 "U1" H 14075 3025 50  0000 C CNN
F 1 "MAX77734_BGA" H 13325 3025 50  0000 C CNN
F 2 "Power.Management.IC:MAX77734_BGA" H 13575 2415 50  0001 C CNN
F 3 "" H 12575 2175 50  0000 C CNN
	1    13575 2175
	1    0    0    -1  
$EndComp
$Comp
L power:+VSW #PWR0106
U 1 1 5C0044DD
P 9700 1425
F 0 "#PWR0106" H 9700 1275 50  0001 C CNN
F 1 "+VSW" H 9715 1598 50  0000 C CNN
F 2 "" H 9700 1425 50  0001 C CNN
F 3 "" H 9700 1425 50  0001 C CNN
	1    9700 1425
	1    0    0    -1  
$EndComp
Wire Wire Line
	9150 2075 9150 2375
Wire Wire Line
	9400 2075 9400 2375
Wire Wire Line
	9400 1775 9400 1475
Wire Wire Line
	9150 1475 9400 1475
Connection ~ 9150 1475
Wire Wire Line
	9150 1775 9150 1475
Wire Wire Line
	9150 2375 9400 2375
Wire Wire Line
	8900 1475 9150 1475
Connection ~ 8900 1475
$Comp
L power:GND #PWR0105
U 1 1 5BFC56B3
P 9700 2425
F 0 "#PWR0105" H 9700 2175 50  0001 C CNN
F 1 "GND" H 9705 2252 50  0000 C CNN
F 2 "" H 9700 2425 50  0001 C CNN
F 3 "" H 9700 2425 50  0001 C CNN
	1    9700 2425
	1    0    0    -1  
$EndComp
$Comp
L Device:R R57
U 1 1 5BFC558A
P 9700 1675
F 0 "R57" H 9770 1721 50  0000 L CNN
F 1 "100" H 9770 1630 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 9630 1675 50  0001 C CNN
F 3 "~" H 9700 1675 50  0001 C CNN
	1    9700 1675
	1    0    0    -1  
$EndComp
$Comp
L Device:C C4
U 1 1 5BFC52DC
P 11275 3025
F 0 "C4" H 11300 3125 50  0000 L CNN
F 1 "0.1uF" H 11300 2925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 11313 2875 50  0001 C CNN
F 3 "~" H 11275 3025 50  0001 C CNN
	1    11275 3025
	1    0    0    -1  
$EndComp
$Comp
L Device:C C52
U 1 1 5BFC527C
P 9400 1925
F 0 "C52" H 9425 2025 50  0000 L CNN
F 1 "0.1uF" H 9425 1825 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 9438 1775 50  0001 C CNN
F 3 "~" H 9400 1925 50  0001 C CNN
	1    9400 1925
	1    0    0    -1  
$EndComp
$Comp
L Device:C C51
U 1 1 5BFC51B2
P 9150 1925
F 0 "C51" H 9175 2025 50  0000 L CNN
F 1 "10uF" H 9175 1825 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 9188 1775 50  0001 C CNN
F 3 "~" H 9150 1925 50  0001 C CNN
	1    9150 1925
	1    0    0    -1  
$EndComp
Connection ~ 8250 4525
Wire Wire Line
	8250 4625 8250 4525
$Comp
L power:GND #PWR0104
U 1 1 5BFBD37D
P 8250 4625
F 0 "#PWR0104" H 8250 4375 50  0001 C CNN
F 1 "GND" H 8255 4452 50  0000 C CNN
F 2 "" H 8250 4625 50  0001 C CNN
F 3 "" H 8250 4625 50  0001 C CNN
	1    8250 4625
	1    0    0    -1  
$EndComp
Connection ~ 8950 4525
Wire Wire Line
	8950 4425 8950 4525
Wire Wire Line
	9650 4525 9900 4525
Connection ~ 9650 4525
Wire Wire Line
	9650 4425 9650 4525
Wire Wire Line
	9900 4525 10150 4525
Connection ~ 9900 4525
Wire Wire Line
	9900 4425 9900 4525
Wire Wire Line
	10150 4425 10150 4525
Wire Wire Line
	8250 4525 8950 4525
Wire Wire Line
	8250 4225 8250 4525
Connection ~ 9900 3625
Wire Wire Line
	10150 3625 10150 4125
Wire Wire Line
	9900 3625 10150 3625
Connection ~ 9650 3625
Wire Wire Line
	9900 3625 9900 4125
Wire Wire Line
	9650 3625 9900 3625
Connection ~ 9400 3625
Wire Wire Line
	9650 3625 9650 4125
Wire Wire Line
	9400 3625 9650 3625
$Comp
L Device:R R56
U 1 1 5BF9DBC6
P 10450 4275
F 0 "R56" H 10520 4321 50  0000 L CNN
F 1 "10k" H 10520 4230 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 10380 4275 50  0001 C CNN
F 3 "~" H 10450 4275 50  0001 C CNN
	1    10450 4275
	1    0    0    -1  
$EndComp
$Comp
L Device:C C67
U 1 1 5BF9DB6E
P 10150 4275
F 0 "C67" H 10175 4375 50  0000 L CNN
F 1 "10uF" H 10175 4175 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 10188 4125 50  0001 C CNN
F 3 "~" H 10150 4275 50  0001 C CNN
	1    10150 4275
	1    0    0    -1  
$EndComp
$Comp
L Device:C C66
U 1 1 5BF9D964
P 9900 4275
F 0 "C66" H 9925 4375 50  0000 L CNN
F 1 "0.1uF" H 9925 4175 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 9938 4125 50  0001 C CNN
F 3 "~" H 9900 4275 50  0001 C CNN
	1    9900 4275
	1    0    0    -1  
$EndComp
$Comp
L Device:C C65
U 1 1 5BF9D8EC
P 9650 4275
F 0 "C65" H 9675 4375 50  0000 L CNN
F 1 "10uF" H 9675 4175 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 9688 4125 50  0001 C CNN
F 3 "~" H 9650 4275 50  0001 C CNN
	1    9650 4275
	1    0    0    -1  
$EndComp
Wire Wire Line
	9400 3975 9400 4025
Wire Wire Line
	9400 3625 9400 3675
Wire Wire Line
	8750 3625 9400 3625
Wire Wire Line
	9200 3825 9200 3875
Connection ~ 9200 3825
Wire Wire Line
	9250 3825 9200 3825
Wire Wire Line
	9200 3775 9200 3825
Connection ~ 8950 4025
Wire Wire Line
	8950 4125 8950 4025
Wire Wire Line
	8750 4025 8950 4025
$Comp
L Device:R R53
U 1 1 5BF6F13C
P 9400 3825
F 0 "R53" H 9470 3871 50  0000 L CNN
F 1 "20k" H 9470 3780 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 9330 3825 50  0001 C CNN
F 3 "~" H 9400 3825 50  0001 C CNN
	1    9400 3825
	1    0    0    -1  
$EndComp
$Comp
L Device:R R52
U 1 1 5BF6F0CE
P 9050 3875
F 0 "R52" V 9150 3775 50  0000 C CNN
F 1 "1M" V 9150 3925 50  0000 C CNN
F 2 "Resistor_SMD:R_0603_1608Metric" V 8980 3875 50  0001 C CNN
F 3 "~" H 9050 3875 50  0001 C CNN
	1    9050 3875
	0    1    1    0   
$EndComp
$Comp
L Device:R R51
U 1 1 5BF6EE7B
P 9050 3775
F 0 "R51" V 8950 3675 50  0000 C CNN
F 1 "75" V 8950 3825 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8980 3775 50  0001 C CNN
F 3 "~" H 9050 3775 50  0001 C CNN
	1    9050 3775
	0    1    1    0   
$EndComp
$Comp
L Device:R R55
U 1 1 5BF6EE2F
P 9250 4275
F 0 "R55" H 9320 4321 50  0000 L CNN
F 1 "196" H 9320 4230 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 9180 4275 50  0001 C CNN
F 3 "~" H 9250 4275 50  0001 C CNN
	1    9250 4275
	1    0    0    -1  
$EndComp
$Comp
L Device:R R54
U 1 1 5BF6ED0F
P 8950 4275
F 0 "R54" H 9020 4321 50  0000 L CNN
F 1 "1M" H 9020 4230 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8880 4275 50  0001 C CNN
F 3 "~" H 8950 4275 50  0001 C CNN
	1    8950 4275
	1    0    0    -1  
$EndComp
Connection ~ 8900 2025
Wire Wire Line
	8900 1475 8900 2025
Wire Wire Line
	8000 1475 8900 1475
Wire Wire Line
	8900 2625 8750 2625
Wire Wire Line
	8900 2025 8900 2625
Wire Wire Line
	8300 2025 8900 2025
Wire Wire Line
	7200 2025 7200 2725
Connection ~ 7200 2025
Wire Wire Line
	7400 2025 7200 2025
Connection ~ 7200 1475
Wire Wire Line
	7200 2725 7750 2725
Wire Wire Line
	7200 1475 7200 2025
Wire Wire Line
	7700 1475 7200 1475
$Comp
L power:VBUS #PWR0103
U 1 1 5BF64F69
P 7200 1475
F 0 "#PWR0103" H 7200 1325 50  0001 C CNN
F 1 "VBUS" H 7215 1648 50  0000 C CNN
F 2 "" H 7200 1475 50  0001 C CNN
F 3 "" H 7200 1475 50  0001 C CNN
	1    7200 1475
	1    0    0    -1  
$EndComp
$Comp
L Device:R R3
U 1 1 5BF6453E
P 7850 1475
F 0 "R3" V 7750 1475 50  0000 C CNN
F 1 "0R" V 7950 1475 50  0000 C CNN
F 2 "Resistor_SMD:R_0603_1608Metric" V 7780 1475 50  0001 C CNN
F 3 "~" H 7850 1475 50  0001 C CNN
	1    7850 1475
	0    1    1    0   
$EndComp
Wire Wire Line
	7750 1775 7950 1775
Connection ~ 7650 2275
Wire Wire Line
	7650 2625 7750 2625
Wire Wire Line
	7650 2275 7650 2625
Wire Wire Line
	8050 2275 7650 2275
Wire Wire Line
	6000 3625 6000 3925
Connection ~ 6000 3625
Wire Wire Line
	6050 3625 6000 3625
Wire Wire Line
	6000 3325 6000 3625
Connection ~ 6000 3325
Wire Wire Line
	6050 3325 6000 3325
Wire Wire Line
	6000 3025 6000 3325
Wire Wire Line
	6050 3025 6000 3025
Wire Wire Line
	6500 3625 6350 3625
Wire Wire Line
	6500 3325 6500 3625
Connection ~ 6500 3325
Wire Wire Line
	6350 3325 6500 3325
Wire Wire Line
	6500 3025 6350 3025
Wire Wire Line
	7350 3325 7350 3375
Wire Wire Line
	7350 3325 7000 3325
Connection ~ 7350 3325
Wire Wire Line
	7350 3225 7350 3325
Wire Wire Line
	7000 3325 7000 3375
Wire Wire Line
	7000 3325 6650 3325
Connection ~ 7000 3325
Wire Wire Line
	7000 3125 7000 3325
Wire Wire Line
	6650 3025 6650 3325
Wire Wire Line
	6650 3325 6500 3325
Connection ~ 6650 3325
Wire Wire Line
	6650 3375 6650 3325
Wire Wire Line
	6500 3325 6500 3025
Wire Wire Line
	7350 3675 7350 3725
Wire Wire Line
	7350 3725 7000 3725
Connection ~ 7350 3725
Wire Wire Line
	7350 3825 7350 3725
Wire Wire Line
	7000 3925 7000 3725
Wire Wire Line
	7000 3725 6650 3725
Connection ~ 7000 3725
Wire Wire Line
	7000 3675 7000 3725
Wire Wire Line
	6650 3725 6500 3725
Connection ~ 6650 3725
Wire Wire Line
	6650 3675 6650 3725
Wire Wire Line
	6500 4025 6650 4025
Connection ~ 6500 4025
Wire Wire Line
	6500 3725 6500 4025
Wire Wire Line
	6000 4025 6500 4025
$Comp
L Device:C C55
U 1 1 5BF3E7C6
P 6200 3625
F 0 "C55" V 6150 3675 50  0000 L CNN
F 1 "150nF" V 6250 3675 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 6238 3475 50  0001 C CNN
F 3 "~" H 6200 3625 50  0001 C CNN
	1    6200 3625
	0    1    1    0   
$EndComp
$Comp
L Device:C C54
U 1 1 5BF3E77E
P 6200 3325
F 0 "C54" V 6150 3375 50  0000 L CNN
F 1 "22nF" V 6250 3375 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 6238 3175 50  0001 C CNN
F 3 "~" H 6200 3325 50  0001 C CNN
	1    6200 3325
	0    1    1    0   
$EndComp
$Comp
L Device:C C53
U 1 1 5BF3E72A
P 6200 3025
F 0 "C53" V 6150 3075 50  0000 L CNN
F 1 "15nF" V 6250 3075 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 6238 2875 50  0001 C CNN
F 3 "~" H 6200 3025 50  0001 C CNN
	1    6200 3025
	0    1    1    0   
$EndComp
$Comp
L Connector_Generic:Conn_01x02 J51
U 1 1 5BF3C9BF
P 5800 4025
F 0 "J51" H 5800 3825 50  0000 C CNN
F 1 "Conn_01x02" H 5800 4125 50  0000 C CNN
F 2 "Connector_JST:JST_SHL_SM02B-SHLS-TF_1x02-1MP_P1.00mm_Horizontal" H 5800 4025 50  0001 C CNN
F 3 "~" H 5800 4025 50  0001 C CNN
	1    5800 4025
	-1   0    0    1   
$EndComp
$Comp
L Device:C C59
U 1 1 5BF395DD
P 6800 3025
F 0 "C59" V 6750 3075 50  0000 L CNN
F 1 "470nF" V 6850 3075 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 6838 2875 50  0001 C CNN
F 3 "~" H 6800 3025 50  0001 C CNN
	1    6800 3025
	0    1    1    0   
$EndComp
$Comp
L Device:C C60
U 1 1 5BF3959B
P 7150 3125
F 0 "C60" V 7100 3175 50  0000 L CNN
F 1 "22nF" V 7200 3175 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 7188 2975 50  0001 C CNN
F 3 "~" H 7150 3125 50  0001 C CNN
	1    7150 3125
	0    1    1    0   
$EndComp
$Comp
L Device:C C62
U 1 1 5BF39329
P 6800 4025
F 0 "C62" V 6750 4075 50  0000 L CNN
F 1 "470nF" V 6850 4075 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 6838 3875 50  0001 C CNN
F 3 "~" H 6800 4025 50  0001 C CNN
	1    6800 4025
	0    1    1    0   
$EndComp
$Comp
L Device:C C63
U 1 1 5BF392D7
P 7150 3925
F 0 "C63" V 7100 3975 50  0000 L CNN
F 1 "22nF" V 7200 3975 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 7188 3775 50  0001 C CNN
F 3 "~" H 7150 3925 50  0001 C CNN
	1    7150 3925
	0    1    1    0   
$EndComp
$Comp
L Device:C C64
U 1 1 5BF3928D
P 7500 3825
F 0 "C64" V 7450 3875 50  0000 L CNN
F 1 "10nF" V 7550 3875 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 7538 3675 50  0001 C CNN
F 3 "~" H 7500 3825 50  0001 C CNN
	1    7500 3825
	0    1    1    0   
$EndComp
$Comp
L Device:C C61
U 1 1 5BF38F45
P 7500 3225
F 0 "C61" V 7450 3275 50  0000 L CNN
F 1 "10nF" V 7550 3275 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 7538 3075 50  0001 C CNN
F 3 "~" H 7500 3225 50  0001 C CNN
	1    7500 3225
	0    1    1    0   
$EndComp
$Comp
L Device:C C56
U 1 1 5BF38DC8
P 6650 3525
F 0 "C56" H 6675 3625 50  0000 L CNN
F 1 "470pF" H 6675 3425 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 6688 3375 50  0001 C CNN
F 3 "~" H 6650 3525 50  0001 C CNN
	1    6650 3525
	1    0    0    -1  
$EndComp
$Comp
L Device:C C57
U 1 1 5BF38D94
P 7000 3525
F 0 "C57" H 7025 3625 50  0000 L CNN
F 1 "1.5nF" H 7025 3425 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 7038 3375 50  0001 C CNN
F 3 "~" H 7000 3525 50  0001 C CNN
	1    7000 3525
	1    0    0    -1  
$EndComp
$Comp
L Device:C C58
U 1 1 5BF38C46
P 7350 3525
F 0 "C58" H 7375 3625 50  0000 L CNN
F 1 "15pF" H 7375 3425 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 7388 3375 50  0001 C CNN
F 3 "~" H 7350 3525 50  0001 C CNN
	1    7350 3525
	1    0    0    -1  
$EndComp
$Comp
L Power.Management.IC:BQ51013B U51
U 1 1 5BF38818
P 8250 3325
F 0 "U51" H 8575 4175 50  0000 C CNN
F 1 "BQ51013B" H 8050 4175 50  0000 C CNN
F 2 "Package_DFN_QFN:Texas_VQFN-RHL-20" H 8250 3325 50  0001 C CNN
F 3 "" H 8250 3325 50  0001 C CNN
	1    8250 3325
	1    0    0    -1  
$EndComp
$Comp
L Discrete_elemets:Dual_Common_Source_P-FET_BGA U52
U 1 1 5BF35C8D
P 7850 2025
F 0 "U52" V 8050 1825 50  0000 R CNN
F 1 "CSD75208W1015" V 8150 2325 50  0000 R CNN
F 2 "Package_BGA:Texas_DSBGA-6_0.9x1.4mm_Layout2x3_P0.5mm" H 7800 1625 50  0001 C CIN
F 3 "" H 7710 2030 50  0001 L CNN
	1    7850 2025
	0    -1   -1   0   
$EndComp
$Comp
L Interface_USB:FT230XQ U42
U 1 1 5BEEB067
P 5325 2000
F 0 "U42" H 5775 2600 50  0000 C CNN
F 1 "FT230XQ" H 4925 2600 50  0000 C CNN
F 2 "Package_DFN_QFN:QFN-16-1EP_4x4mm_P0.65mm_EP2.1x2.1mm" H 5875 1300 50  0001 C CNN
F 3 "http://www.ftdichip.com/Products/ICs/FT230X.html" H 5325 2000 50  0001 C CNN
	1    5325 2000
	1    0    0    -1  
$EndComp
$Comp
L Device:R R41
U 1 1 5BEEB1C0
P 4375 1900
F 0 "R41" V 4275 1825 50  0000 C CNN
F 1 "27" V 4275 1975 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4305 1900 50  0001 C CNN
F 3 "~" H 4375 1900 50  0001 C CNN
	1    4375 1900
	0    1    1    0   
$EndComp
$Comp
L Device:R R42
U 1 1 5BEEB3B3
P 4375 2000
F 0 "R42" V 4475 1925 50  0000 C CNN
F 1 "27" V 4475 2075 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4305 2000 50  0001 C CNN
F 3 "~" H 4375 2000 50  0001 C CNN
	1    4375 2000
	0    1    1    0   
$EndComp
Wire Wire Line
	4525 1900 4625 1900
Wire Wire Line
	4525 2000 4625 2000
Wire Wire Line
	4625 2200 4575 2200
Wire Wire Line
	4575 2200 4575 1600
Wire Wire Line
	4575 1600 4625 1600
Wire Wire Line
	5425 1250 5425 1300
$Comp
L Device:C C2
U 1 1 5BEEB859
P 2775 2500
F 0 "C2" H 2800 2600 50  0000 L CNN
F 1 "0.1uF" H 2800 2400 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2813 2350 50  0001 C CNN
F 3 "~" H 2775 2500 50  0001 C CNN
	1    2775 2500
	1    0    0    -1  
$EndComp
$Comp
L Device:C C1
U 1 1 5BEEB8CD
P 2525 2500
F 0 "C1" H 2400 2600 50  0000 L CNN
F 1 "10uF" H 2325 2400 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 2563 2350 50  0001 C CNN
F 3 "~" H 2525 2500 50  0001 C CNN
	1    2525 2500
	1    0    0    -1  
$EndComp
Wire Wire Line
	5225 1150 5225 1300
$Comp
L power:GND #PWR0101
U 1 1 5BEED772
P 1775 2850
F 0 "#PWR0101" H 1775 2600 50  0001 C CNN
F 1 "GND" H 1780 2677 50  0000 C CNN
F 2 "" H 1775 2850 50  0001 C CNN
F 3 "" H 1775 2850 50  0001 C CNN
	1    1775 2850
	1    0    0    -1  
$EndComp
Wire Wire Line
	5425 2800 5425 2700
Wire Wire Line
	5225 2700 5225 2800
Connection ~ 5225 2800
Wire Wire Line
	5225 2800 5325 2800
Wire Wire Line
	5325 2700 5325 2800
Connection ~ 5325 2800
Wire Wire Line
	5325 2800 5425 2800
$Comp
L Device:C C44
U 1 1 5BEEEEF4
P 4575 2500
F 0 "C44" H 4600 2600 50  0000 L CNN
F 1 "0.1uF" H 4600 2400 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 4613 2350 50  0001 C CNN
F 3 "~" H 4575 2500 50  0001 C CNN
	1    4575 2500
	1    0    0    -1  
$EndComp
Wire Wire Line
	2525 2650 2525 2800
Wire Wire Line
	2775 2650 2775 2800
Wire Wire Line
	4575 2650 4575 2800
Connection ~ 4575 2800
Wire Wire Line
	4575 2800 5225 2800
Wire Wire Line
	4575 2350 4575 2200
Connection ~ 4575 2200
Wire Wire Line
	1775 2800 1775 2850
Wire Wire Line
	2775 2250 2525 2250
Wire Wire Line
	2775 2250 2775 2350
Connection ~ 2525 2250
Wire Wire Line
	2525 2250 2525 2350
Wire Wire Line
	2525 2800 2775 2800
Connection ~ 2775 2800
$Comp
L power:VBUS #PWR0102
U 1 1 5BF6488A
P 2525 1050
F 0 "#PWR0102" H 2525 900 50  0001 C CNN
F 1 "VBUS" H 2540 1223 50  0000 C CNN
F 2 "" H 2525 1050 50  0001 C CNN
F 3 "" H 2525 1050 50  0001 C CNN
	1    2525 1050
	1    0    0    -1  
$EndComp
$Comp
L Device:C C41
U 1 1 5C04665C
P 3675 2500
F 0 "C41" H 3700 2600 50  0000 L CNN
F 1 "0.1uF" H 3700 2400 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 3713 2350 50  0001 C CNN
F 3 "~" H 3675 2500 50  0001 C CNN
	1    3675 2500
	1    0    0    -1  
$EndComp
Wire Wire Line
	3675 2650 3675 2800
$Comp
L Device:C C42
U 1 1 5C050143
P 3925 2500
F 0 "C42" H 3950 2600 50  0000 L CNN
F 1 "47pF" H 3950 2400 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 3963 2350 50  0001 C CNN
F 3 "~" H 3925 2500 50  0001 C CNN
	1    3925 2500
	1    0    0    -1  
$EndComp
$Comp
L Device:C C43
U 1 1 5C0501DB
P 4175 2500
F 0 "C43" H 4200 2600 50  0000 L CNN
F 1 "47pF" H 4200 2400 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 4213 2350 50  0001 C CNN
F 3 "~" H 4175 2500 50  0001 C CNN
	1    4175 2500
	1    0    0    -1  
$EndComp
Wire Wire Line
	3925 2650 3925 2800
Wire Wire Line
	4175 2650 4175 2800
Wire Wire Line
	4175 2350 4175 2000
Wire Wire Line
	4225 2000 4175 2000
Wire Wire Line
	3925 2350 3925 1900
$Comp
L Device:Ferrite_Bead_Small FB41
U 1 1 5C070D12
P 4150 1150
F 0 "FB41" V 4000 1150 50  0000 C CNN
F 1 "BLM03BD241SN1D" V 4300 1150 50  0000 C CNN
F 2 "Inductor_SMD:L_0201_0603Metric" V 4080 1150 50  0001 C CNN
F 3 "~" H 4150 1150 50  0001 C CNN
	1    4150 1150
	0    1    1    0   
$EndComp
Text GLabel 6025 1600 2    50   Output ~ 0
TXD
Text GLabel 6025 1700 2    50   Input ~ 0
RXD
Text GLabel 6025 1800 2    50   Output ~ 0
nRTS
Text GLabel 6025 1900 2    50   Input ~ 0
nCTS
$Comp
L Connector:USB_C_Receptacle_USB2.0 J1
U 1 1 5C9D49E6
P 1175 1900
F 0 "J1" H 1280 2767 50  0000 C CNN
F 1 "USB_C_Receptacle_USB2.0" H 1280 2676 50  0000 C CNN
F 2 "Connector_USB:USB_C_Receptacle_Amphenol_12401548E4-2A" H 1325 1900 50  0001 C CNN
F 3 "https://www.usb.org/sites/default/files/documents/usb_type-c.zip" H 1325 1900 50  0001 C CNN
	1    1175 1900
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 2800 1175 2800
Connection ~ 1775 2800
Connection ~ 1175 2800
Wire Wire Line
	1175 2800 875  2800
$Comp
L Device:R R2
U 1 1 5CA86A13
P 1950 2550
F 0 "R2" H 2020 2596 50  0000 L CNN
F 1 "5.1k" H 2020 2505 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 1880 2550 50  0001 C CNN
F 3 "~" H 1950 2550 50  0001 C CNN
	1    1950 2550
	1    0    0    -1  
$EndComp
$Comp
L Device:R R1
U 1 1 5CA86CAB
P 2225 2200
F 0 "R1" H 2295 2246 50  0000 L CNN
F 1 "5.1k" H 2295 2155 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 2155 2200 50  0001 C CNN
F 3 "~" H 2225 2200 50  0001 C CNN
	1    2225 2200
	1    0    0    -1  
$EndComp
Wire Wire Line
	1950 2700 1950 2800
Wire Wire Line
	2225 2350 2225 2800
Wire Wire Line
	2225 2050 2225 1500
Wire Wire Line
	1950 1600 1950 2400
Wire Wire Line
	1775 1900 1775 1800
Wire Wire Line
	1775 2100 1775 2000
Connection ~ 4175 2800
Wire Wire Line
	4175 2800 4575 2800
Wire Wire Line
	3925 2800 4175 2800
Wire Wire Line
	4225 1900 3925 1900
Connection ~ 1950 2800
Wire Wire Line
	1775 2800 1950 2800
Wire Wire Line
	1775 1600 1950 1600
Wire Wire Line
	1775 1500 2225 1500
Wire Wire Line
	1950 2800 2225 2800
Connection ~ 2525 2800
Connection ~ 2225 2800
Wire Wire Line
	2225 2800 2525 2800
Connection ~ 3925 2800
Wire Wire Line
	2525 1050 2525 1150
Connection ~ 3675 2800
Wire Wire Line
	3675 2800 3925 2800
Wire Wire Line
	2775 2800 3225 2800
Wire Wire Line
	5225 1150 4250 1150
Wire Wire Line
	3675 1150 4050 1150
Wire Wire Line
	3675 1150 3675 2350
$Comp
L Discrete_elemets:USBLC6 U41
U 1 1 5D0568D1
P 3225 2000
F 0 "U41" H 3375 2350 50  0000 C CNN
F 1 "USBLC6" H 3425 1725 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23-6" H 2475 2400 50  0001 C CNN
F 3 "http://www2.st.com/resource/en/datasheet/CD00050750.pdf" H 3425 2350 50  0001 C CNN
	1    3225 2000
	-1   0    0    -1  
$EndComp
Wire Wire Line
	3225 2300 3225 2800
Connection ~ 3225 2800
Wire Wire Line
	3225 2800 3675 2800
Wire Wire Line
	3675 1150 3225 1150
Connection ~ 3675 1150
Connection ~ 2525 1150
Wire Wire Line
	2525 1150 2525 2250
Wire Wire Line
	3225 1600 3225 1150
Connection ~ 3225 1150
Wire Wire Line
	3225 1150 2525 1150
Wire Wire Line
	3525 1900 3925 1900
Connection ~ 3925 1900
Wire Wire Line
	3525 2000 4175 2000
Connection ~ 4175 2000
Wire Wire Line
	2925 1900 1775 1900
Connection ~ 1775 1900
Wire Wire Line
	2925 2000 1775 2000
Connection ~ 1775 2000
Wire Wire Line
	14350 7600 14250 7600
Text GLabel 14350 7600 2    50   Output ~ 0
Load
Text Notes 10075 6200 0    50   ~ 0
PCB Inverted F-Antenna \nSWRU120D (DN007, vecja)\nali\nSWRA117D (TI AN043)
Wire Wire Line
	11850 7300 12450 7300
Wire Wire Line
	11850 6900 12450 6900
Wire Wire Line
	12125 6400 12450 6400
Wire Wire Line
	12050 7100 12150 7100
$Comp
L power:GND #PWR06
U 1 1 5E65E757
P 12150 7100
F 0 "#PWR06" H 12150 6850 50  0001 C CNN
F 1 "GND" H 12275 7025 50  0000 C CNN
F 2 "" H 12150 7100 50  0001 C CNN
F 3 "" H 12150 7100 50  0001 C CNN
	1    12150 7100
	1    0    0    -1  
$EndComp
Wire Wire Line
	11250 7100 11250 7300
Connection ~ 11250 7100
Wire Wire Line
	11650 7100 11250 7100
Wire Wire Line
	13350 4800 13550 4800
Connection ~ 13350 4800
Wire Wire Line
	13350 5400 13350 4800
Wire Wire Line
	13350 4700 13350 4800
Connection ~ 13550 4800
Connection ~ 14025 4800
Wire Wire Line
	14025 4800 13550 4800
Wire Wire Line
	14275 5250 14525 5250
Connection ~ 14775 5250
Wire Wire Line
	14275 4800 14525 4800
Wire Wire Line
	14350 5600 14250 5600
Text GLabel 14350 5600 2    50   Output ~ 0
LED_B
Text GLabel 15350 8000 2    50   3State ~ 0
SDA
Text GLabel 15350 8100 2    50   Output ~ 0
SCL
Text GLabel 14350 5800 2    50   UnSpc ~ 0
AMUX
Text GLabel 14350 6000 2    50   Output ~ 0
APower
Text GLabel 14350 6100 2    50   Input ~ 0
nRTS
Text GLabel 14350 6200 2    50   Input ~ 0
TXD
Text GLabel 14350 6300 2    50   Output ~ 0
nCTS
Text GLabel 14350 6400 2    50   Output ~ 0
RXD
Text GLabel 14350 6700 2    50   Input ~ 0
ADC_DOUT
Text GLabel 14350 6800 2    50   Output ~ 0
ADC_SCK
Text GLabel 14350 8600 2    50   Output ~ 0
W_En2
Text GLabel 14350 8500 2    50   Output ~ 0
W_En1
Text GLabel 14350 8400 2    50   Input ~ 0
W_nCHG
Text GLabel 14350 8300 2    50   Input ~ 0
nIRQ
Text GLabel 14350 6900 2    50   Output ~ 0
ADC_RATE
$Comp
L power:GND #PWR0113
U 1 1 5C1C2163
P 13350 8900
F 0 "#PWR0113" H 13350 8650 50  0001 C CNN
F 1 "GND" H 13355 8727 50  0000 C CNN
F 2 "" H 13350 8900 50  0001 C CNN
F 3 "" H 13350 8900 50  0001 C CNN
	1    13350 8900
	1    0    0    -1  
$EndComp
$Comp
L Connector_Generic:Conn_01x05 J2
U 1 1 5C364572
P 10925 7800
F 0 "J2" H 10875 8100 50  0000 L CNN
F 1 "Conn_01x05" H 10875 7500 50  0000 L CNN
F 2 "" H 10925 7800 50  0001 C CNN
F 3 "~" H 10925 7800 50  0001 C CNN
	1    10925 7800
	-1   0    0    -1  
$EndComp
$Comp
L Connector:Conn_ARM_JTAG_SWD_10 J3
U 1 1 5C3649AA
P 11675 8575
F 0 "J3" H 11375 9125 50  0000 R CNN
F 1 "JTAG_SWD_10" H 11525 7975 50  0000 R CNN
F 2 "Connector_PinHeader_1.27mm:PinHeader_2x05_P1.27mm_Vertical_SMD" H 11725 8025 50  0001 L TNN
F 3 "http://infocenter.arm.com/help/topic/com.arm.doc.faqs/attached/13634/cortex_debug_connectors.pdf" V 11325 7325 50  0001 C CNN
	1    11675 8575
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR0115
U 1 1 5C599D91
P 11675 9375
F 0 "#PWR0115" H 11675 9125 50  0001 C CNN
F 1 "GND" H 11680 9202 50  0000 C CNN
F 2 "" H 11675 9375 50  0001 C CNN
F 3 "" H 11675 9375 50  0001 C CNN
	1    11675 9375
	1    0    0    -1  
$EndComp
Wire Wire Line
	11675 9375 11675 9275
Wire Wire Line
	11675 9175 11675 9275
Wire Wire Line
	11675 9275 11575 9275
Connection ~ 11675 9275
Wire Wire Line
	11575 9275 11575 9175
$Comp
L Device:R R15
U 1 1 5C75477B
P 14900 7750
F 0 "R15" H 14970 7796 50  0000 L CNN
F 1 "4.7k" H 14970 7705 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 14830 7750 50  0001 C CNN
F 3 "~" H 14900 7750 50  0001 C CNN
	1    14900 7750
	1    0    0    -1  
$EndComp
$Comp
L Device:R R16
U 1 1 5C7549C1
P 15200 7750
F 0 "R16" H 15270 7796 50  0000 L CNN
F 1 "4.7k" H 15270 7705 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 15130 7750 50  0001 C CNN
F 3 "~" H 15200 7750 50  0001 C CNN
	1    15200 7750
	1    0    0    -1  
$EndComp
$Comp
L Device:C C22
U 1 1 5CAD8858
P 14025 5025
F 0 "C22" H 14050 5125 50  0000 L CNN
F 1 "0.1uF" H 14050 4925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 14063 4875 50  0001 C CNN
F 3 "~" H 14025 5025 50  0001 C CNN
	1    14025 5025
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR0116
U 1 1 5CAF4207
P 14775 5325
F 0 "#PWR0116" H 14775 5075 50  0001 C CNN
F 1 "GND" H 14780 5152 50  0000 C CNN
F 2 "" H 14775 5325 50  0001 C CNN
F 3 "" H 14775 5325 50  0001 C CNN
	1    14775 5325
	1    0    0    -1  
$EndComp
Text GLabel 14350 7700 2    50   Input ~ 0
POWER
Text GLabel 14350 7900 2    50   Output ~ 0
PMLDO
Text GLabel 14350 7800 2    50   Input ~ 0
POkLDO
$Comp
L MCU_Nordic:nRF52832-QFxx U3
U 1 1 5CBD1015
P 13350 7100
F 0 "U3" H 14100 8750 50  0000 C CNN
F 1 "nRF52832-QFxx" H 13850 5425 50  0000 C CNN
F 2 "Package_DFN_QFN:QFN-48-1EP_6x6mm_P0.4mm_EP4.6x4.6mm" H 13350 5000 50  0001 C CNN
F 3 "http://infocenter.nordicsemi.com/pdf/nRF52832_PS_v1.4.pdf" H 12850 7300 50  0001 C CNN
	1    13350 7100
	1    0    0    -1  
$EndComp
$Comp
L Device:Crystal_GND24 Y1
U 1 1 5CD196F7
P 11850 7100
F 0 "Y1" V 11804 7344 50  0000 L CNN
F 1 "MCSJK-7F-32.00-8" V 12125 6925 50  0000 L CNN
F 2 "" H 11850 7100 50  0001 C CNN
F 3 "~" H 11850 7100 50  0001 C CNN
	1    11850 7100
	0    1    1    0   
$EndComp
$Comp
L Device:Antenna_Shield AE1
U 1 1 5CD1C41F
P 11350 6100
F 0 "AE1" H 11270 6139 50  0000 R CNN
F 1 "Antenna_Shield" H 11270 6048 50  0000 R CNN
F 2 "" H 11350 6200 50  0001 C CNN
F 3 "~" H 11350 6200 50  0001 C CNN
	1    11350 6100
	-1   0    0    -1  
$EndComp
$Comp
L pspice:INDUCTOR L4
U 1 1 5CD3E47F
P 11750 6400
F 0 "L4" H 11750 6500 50  0000 C CNN
F 1 "3.9nH" H 11750 6350 50  0000 C CNN
F 2 "Inductor_SMD:L_0603_1608Metric" H 11750 6400 50  0001 C CNN
F 3 "~" H 11750 6400 50  0001 C CNN
	1    11750 6400
	1    0    0    -1  
$EndComp
$Comp
L Device:C C15
U 1 1 5CD3EDE2
P 12125 6550
F 0 "C15" H 12150 6650 50  0000 L CNN
F 1 "0.8pF" H 12150 6450 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 12163 6400 50  0001 C CNN
F 3 "~" H 12125 6550 50  0001 C CNN
	1    12125 6550
	1    0    0    -1  
$EndComp
$Comp
L Device:C C14
U 1 1 5CD3FB47
P 11350 6550
F 0 "C14" H 11375 6650 50  0000 L CNN
F 1 "DNP" H 11375 6450 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 11388 6400 50  0001 C CNN
F 3 "~" H 11350 6550 50  0001 C CNN
	1    11350 6550
	1    0    0    -1  
$EndComp
$Comp
L Device:C C16
U 1 1 5CD40CDC
P 11400 6900
F 0 "C16" V 11350 6950 50  0000 L CNN
F 1 "8pF" V 11450 6950 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 11438 6750 50  0001 C CNN
F 3 "~" H 11400 6900 50  0001 C CNN
	1    11400 6900
	0    1    1    0   
$EndComp
$Comp
L Device:C C17
U 1 1 5CD421A1
P 11400 7300
F 0 "C17" V 11350 7350 50  0000 L CNN
F 1 "8pF" V 11450 7350 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 11438 7150 50  0001 C CNN
F 3 "~" H 11400 7300 50  0001 C CNN
	1    11400 7300
	0    1    1    0   
$EndComp
$Comp
L Device:C C21
U 1 1 5CD42A2C
P 12250 5475
F 0 "C21" H 12275 5575 50  0000 L CNN
F 1 "0.1uF" H 12275 5375 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 12288 5325 50  0001 C CNN
F 3 "~" H 12250 5475 50  0001 C CNN
	1    12250 5475
	1    0    0    -1  
$EndComp
$Comp
L Device:C C20
U 1 1 5CD440F4
P 12000 5475
F 0 "C20" H 12025 5575 50  0000 L CNN
F 1 "DNP" H 12025 5375 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 12038 5325 50  0001 C CNN
F 3 "~" H 12000 5475 50  0001 C CNN
	1    12000 5475
	1    0    0    -1  
$EndComp
$Comp
L Device:C C19
U 1 1 5CD467CB
P 11750 5475
F 0 "C19" H 11775 5575 50  0000 L CNN
F 1 "100pF" H 11775 5375 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 11788 5325 50  0001 C CNN
F 3 "~" H 11750 5475 50  0001 C CNN
	1    11750 5475
	1    0    0    -1  
$EndComp
$Comp
L Device:C C18
U 1 1 5CD467D1
P 11500 5475
F 0 "C18" H 11525 5575 50  0000 L CNN
F 1 "1.0uF" H 11525 5375 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 11538 5325 50  0001 C CNN
F 3 "~" H 11500 5475 50  0001 C CNN
	1    11500 5475
	1    0    0    -1  
$EndComp
$Comp
L Device:C C25
U 1 1 5CD67C29
P 14775 5025
F 0 "C25" H 14800 5125 50  0000 L CNN
F 1 "0.1uF" H 14800 4925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 14813 4875 50  0001 C CNN
F 3 "~" H 14775 5025 50  0001 C CNN
	1    14775 5025
	1    0    0    -1  
$EndComp
$Comp
L Device:C C24
U 1 1 5CD67C2F
P 14525 5025
F 0 "C24" H 14550 5125 50  0000 L CNN
F 1 "0.1uF" H 14550 4925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 14563 4875 50  0001 C CNN
F 3 "~" H 14525 5025 50  0001 C CNN
	1    14525 5025
	1    0    0    -1  
$EndComp
$Comp
L Device:C C23
U 1 1 5CD67C35
P 14275 5025
F 0 "C23" H 14300 5125 50  0000 L CNN
F 1 "0.1uF" H 14300 4925 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 14313 4875 50  0001 C CNN
F 3 "~" H 14275 5025 50  0001 C CNN
	1    14275 5025
	1    0    0    -1  
$EndComp
Wire Wire Line
	11125 7700 12175 7700
Wire Wire Line
	11125 7800 12275 7800
Wire Wire Line
	11125 7900 12375 7900
Wire Wire Line
	11125 7600 11675 7600
Wire Wire Line
	11675 7600 11675 7975
Wire Wire Line
	12175 8275 12175 7700
Connection ~ 12175 7700
Wire Wire Line
	12175 7700 12450 7700
Wire Wire Line
	12175 8475 12275 8475
Wire Wire Line
	12275 8475 12275 7800
Connection ~ 12275 7800
Wire Wire Line
	12275 7800 12450 7800
Wire Wire Line
	12175 8575 12375 8575
Wire Wire Line
	12375 8575 12375 7900
Connection ~ 12375 7900
Wire Wire Line
	12375 7900 12450 7900
Wire Wire Line
	11850 7250 11850 7300
Connection ~ 11850 7300
Wire Wire Line
	11850 7300 11550 7300
Wire Wire Line
	11550 6900 11850 6900
Wire Wire Line
	11850 6950 11850 6900
Connection ~ 11850 6900
Connection ~ 12125 6400
Wire Wire Line
	12125 6400 12000 6400
Wire Wire Line
	11350 6300 11350 6400
Wire Wire Line
	11500 6400 11350 6400
Connection ~ 11350 6400
Wire Wire Line
	12125 6700 11350 6700
Connection ~ 11350 6700
Wire Wire Line
	11350 6700 11250 6700
Wire Wire Line
	11250 6300 11250 6700
Wire Wire Line
	11250 6700 11250 6900
Connection ~ 11250 6700
Connection ~ 11250 6900
Wire Wire Line
	11250 6900 11250 7100
$Comp
L power:GND #PWR08
U 1 1 5D116824
P 11250 7375
F 0 "#PWR08" H 11250 7125 50  0001 C CNN
F 1 "GND" H 11255 7202 50  0000 C CNN
F 2 "" H 11250 7375 50  0001 C CNN
F 3 "" H 11250 7375 50  0001 C CNN
	1    11250 7375
	1    0    0    -1  
$EndComp
Wire Wire Line
	11250 7375 11250 7300
Connection ~ 11250 7300
Wire Wire Line
	12250 5225 12850 5225
Wire Wire Line
	12000 5125 12950 5125
Wire Wire Line
	11750 5025 13050 5025
Wire Wire Line
	12250 5625 12250 5725
Wire Wire Line
	12250 5725 12000 5725
$Comp
L power:GND #PWR05
U 1 1 5D742CA0
P 12250 5800
F 0 "#PWR05" H 12250 5550 50  0001 C CNN
F 1 "GND" H 12255 5627 50  0000 C CNN
F 2 "" H 12250 5800 50  0001 C CNN
F 3 "" H 12250 5800 50  0001 C CNN
	1    12250 5800
	1    0    0    -1  
$EndComp
Wire Wire Line
	12250 5800 12250 5725
Connection ~ 12250 5725
Wire Wire Line
	12000 5625 12000 5725
Connection ~ 12000 5725
Wire Wire Line
	12000 5725 11750 5725
Wire Wire Line
	11750 5625 11750 5725
Connection ~ 11750 5725
Wire Wire Line
	11750 5725 11500 5725
Wire Wire Line
	11500 5625 11500 5725
Wire Wire Line
	14250 8000 15200 8000
Wire Wire Line
	15200 7900 15200 8000
Connection ~ 15200 8000
Wire Wire Line
	15200 8000 15350 8000
Wire Wire Line
	15350 8100 14900 8100
Wire Wire Line
	14900 7900 14900 8100
Connection ~ 14900 8100
Wire Wire Line
	14900 8100 14250 8100
Wire Wire Line
	14900 7475 15050 7475
Wire Wire Line
	15200 7475 15200 7600
Wire Wire Line
	14900 7600 14900 7475
Wire Wire Line
	13350 8900 13350 8800
$Comp
L power:GND #PWR010
U 1 1 5DE674C2
P 11125 8100
F 0 "#PWR010" H 11125 7850 50  0001 C CNN
F 1 "GND" H 11130 7927 50  0000 C CNN
F 2 "" H 11125 8100 50  0001 C CNN
F 3 "" H 11125 8100 50  0001 C CNN
	1    11125 8100
	1    0    0    -1  
$EndComp
Wire Wire Line
	11125 8000 11125 8100
$Comp
L power:VCC #PWR09
U 1 1 5DEBC2C9
P 15050 7375
F 0 "#PWR09" H 15050 7225 50  0001 C CNN
F 1 "VCC" H 15067 7548 50  0000 C CNN
F 2 "" H 15050 7375 50  0001 C CNN
F 3 "" H 15050 7375 50  0001 C CNN
	1    15050 7375
	1    0    0    -1  
$EndComp
Wire Wire Line
	15050 7375 15050 7475
Connection ~ 15050 7475
Wire Wire Line
	15050 7475 15200 7475
Wire Wire Line
	14025 4875 14025 4800
Wire Wire Line
	14025 4800 14275 4800
Wire Wire Line
	14775 4800 14775 4875
Wire Wire Line
	14275 4875 14275 4800
Connection ~ 14275 4800
Wire Wire Line
	14525 4875 14525 4800
Connection ~ 14525 4800
Wire Wire Line
	14525 4800 14775 4800
Wire Wire Line
	14025 5175 14025 5250
Wire Wire Line
	14025 5250 14275 5250
Wire Wire Line
	14775 5250 14775 5175
Wire Wire Line
	14275 5175 14275 5250
Connection ~ 14275 5250
Wire Wire Line
	14775 5325 14775 5250
Text GLabel 14350 7400 2    50   Output ~ 0
SWO
Text GLabel 12175 8675 2    50   Input ~ 0
SWO
Wire Wire Line
	14350 7400 14250 7400
Wire Wire Line
	14350 6900 14250 6900
Wire Wire Line
	14350 6800 14250 6800
Wire Wire Line
	14350 6700 14250 6700
Wire Wire Line
	14350 6400 14250 6400
Wire Wire Line
	14350 6300 14250 6300
Wire Wire Line
	14350 6200 14250 6200
Wire Wire Line
	14350 6100 14250 6100
Wire Wire Line
	14350 6000 14250 6000
Wire Wire Line
	14350 5800 14250 5800
Wire Wire Line
	14350 7700 14250 7700
Wire Wire Line
	14350 7800 14250 7800
Wire Wire Line
	14350 7900 14250 7900
Wire Wire Line
	14350 8600 14250 8600
Wire Wire Line
	14350 8500 14250 8500
Wire Wire Line
	14350 8400 14250 8400
Wire Wire Line
	14350 8300 14250 8300
$Comp
L pspice:INDUCTOR L2
U 1 1 5E6D02EA
P 12900 4800
F 0 "L2" H 12900 4900 50  0000 C CNN
F 1 "15nH" H 12900 4750 50  0000 C CNN
F 2 "Inductor_SMD:L_0603_1608Metric" H 12900 4800 50  0001 C CNN
F 3 "~" H 12900 4800 50  0001 C CNN
	1    12900 4800
	1    0    0    -1  
$EndComp
$Comp
L pspice:INDUCTOR L3
U 1 1 5E6D0A50
P 13550 5100
F 0 "L3" V 13350 5225 50  0000 C CNN
F 1 "10uH" V 13450 5300 50  0000 C CNN
F 2 "Inductor_SMD:L_0603_1608Metric" H 13550 5100 50  0001 C CNN
F 3 "~" H 13550 5100 50  0001 C CNN
	1    13550 5100
	0    1    1    0   
$EndComp
Wire Wire Line
	13150 4925 13150 5400
Wire Wire Line
	13050 5025 13050 5400
Wire Wire Line
	12950 5125 12950 5400
Wire Wire Line
	12850 5225 12850 5400
Wire Wire Line
	12250 5225 12250 5325
Wire Wire Line
	12000 5125 12000 5325
Wire Wire Line
	11750 5025 11750 5325
Wire Wire Line
	11500 4925 11500 5325
Wire Wire Line
	11500 4925 12375 4925
Wire Wire Line
	12375 4925 12375 4800
Wire Wire Line
	12375 4800 12650 4800
Connection ~ 12375 4925
Wire Wire Line
	12375 4925 13150 4925
Wire Wire Line
	13150 4800 13350 4800
Wire Wire Line
	13550 5350 13550 5400
Wire Wire Line
	13550 4800 13550 4850
Wire Wire Line
	14525 5175 14525 5250
Connection ~ 14525 5250
Wire Wire Line
	14525 5250 14775 5250
Text GLabel 14350 7000 2    50   Input ~ 0
Tara
Wire Wire Line
	14350 7000 14250 7000
$Comp
L power:VCC #PWR02
U 1 1 5D28BA3C
P 13350 4700
F 0 "#PWR02" H 13350 4550 50  0001 C CNN
F 1 "VCC" H 13367 4873 50  0000 C CNN
F 2 "" H 13350 4700 50  0001 C CNN
F 3 "" H 13350 4700 50  0001 C CNN
	1    13350 4700
	1    0    0    -1  
$EndComp
Wire Wire Line
	4700 9475 4700 9575
Connection ~ 4700 9475
Wire Wire Line
	4775 9475 4700 9475
Wire Wire Line
	4700 9775 4700 9675
Connection ~ 4700 9775
Wire Wire Line
	4775 9775 4700 9775
Wire Wire Line
	4700 9675 4775 9675
Wire Wire Line
	4700 10075 4700 9775
Wire Wire Line
	4700 9575 4775 9575
Wire Wire Line
	4700 9325 4700 9475
Connection ~ 3825 8425
Wire Wire Line
	3150 8425 3825 8425
Wire Wire Line
	3150 8625 3150 8425
Wire Wire Line
	5775 8425 5775 8225
$Comp
L power:VSS #PWR011
U 1 1 5CD1D1E4
P 5775 8225
F 0 "#PWR011" H 5775 8075 50  0001 C CNN
F 1 "VSS" H 5792 8398 50  0000 C CNN
F 2 "" H 5775 8225 50  0001 C CNN
F 3 "" H 5775 8225 50  0001 C CNN
	1    5775 8225
	1    0    0    -1  
$EndComp
Wire Wire Line
	6275 8925 5775 8925
Connection ~ 6275 8925
Wire Wire Line
	6275 8825 6275 8925
Connection ~ 5675 8425
Wire Wire Line
	5675 8425 5675 8975
Text GLabel 6175 9575 2    50   Input ~ 0
ADC_RATE
Connection ~ 5475 10075
Wire Wire Line
	5475 10275 5475 10075
$Comp
L power:GND #PWR0117
U 1 1 5C3AC156
P 5475 10275
F 0 "#PWR0117" H 5475 10025 50  0001 C CNN
F 1 "GND" H 5480 10102 50  0000 C CNN
F 2 "" H 5475 10275 50  0001 C CNN
F 3 "" H 5475 10275 50  0001 C CNN
	1    5475 10275
	1    0    0    -1  
$EndComp
Wire Wire Line
	3825 9175 4775 9175
Wire Wire Line
	3825 9175 3825 8425
Connection ~ 4075 8425
Wire Wire Line
	4075 8425 3825 8425
Wire Wire Line
	5475 8975 5475 8725
Connection ~ 5175 8825
Wire Wire Line
	5175 8975 5175 8825
Wire Wire Line
	4325 8425 4575 8425
Wire Wire Line
	6725 8925 6275 8925
Wire Wire Line
	6725 9175 6725 8925
Wire Wire Line
	6175 9175 6475 9175
Wire Wire Line
	6475 9475 6725 9475
Connection ~ 6475 9475
$Comp
L Device:C C12
U 1 1 5C1AB077
P 6475 9325
F 0 "C12" H 6500 9425 50  0000 L CNN
F 1 "0.1uF" H 6500 9225 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 6513 9175 50  0001 C CNN
F 3 "~" H 6475 9325 50  0001 C CNN
	1    6475 9325
	1    0    0    -1  
$EndComp
$Comp
L power:VCC #PWR0110
U 1 1 5C19D024
P 6275 8825
F 0 "#PWR0110" H 6275 8675 50  0001 C CNN
F 1 "VCC" H 6292 8998 50  0000 C CNN
F 2 "" H 6275 8825 50  0001 C CNN
F 3 "" H 6275 8825 50  0001 C CNN
	1    6275 8825
	1    0    0    -1  
$EndComp
Wire Wire Line
	5775 8425 5675 8425
Wire Wire Line
	5775 8975 5775 8925
Connection ~ 4075 8825
Wire Wire Line
	4075 8875 4075 8825
$Comp
L power:GND #PWR0109
U 1 1 5C159054
P 4075 8875
F 0 "#PWR0109" H 4075 8625 50  0001 C CNN
F 1 "GND" H 4080 8702 50  0000 C CNN
F 2 "" H 4075 8875 50  0001 C CNN
F 3 "" H 4075 8875 50  0001 C CNN
	1    4075 8875
	1    0    0    -1  
$EndComp
Wire Wire Line
	5175 8425 5275 8425
Connection ~ 5175 8425
Wire Wire Line
	5175 8475 5175 8425
Wire Wire Line
	5175 8825 5175 8775
Wire Wire Line
	4975 8825 5175 8825
Wire Wire Line
	4325 8825 4075 8825
Connection ~ 4325 8825
Wire Wire Line
	4325 8775 4325 8825
Wire Wire Line
	4075 8825 4075 8775
Wire Wire Line
	4675 8825 4325 8825
Connection ~ 4325 8425
Wire Wire Line
	4325 8475 4325 8425
Wire Wire Line
	4075 8425 4325 8425
Wire Wire Line
	4075 8475 4075 8425
Wire Wire Line
	5075 8425 5175 8425
Wire Wire Line
	5475 10075 6725 10075
Wire Wire Line
	5475 9975 5475 10075
Wire Wire Line
	6275 9475 6475 9475
Wire Wire Line
	6275 9375 6275 9475
Wire Wire Line
	6175 9375 6275 9375
Connection ~ 6725 9475
Wire Wire Line
	6725 10075 6725 9475
$Comp
L Device:C C13
U 1 1 5C083AF0
P 6725 9325
F 0 "C13" H 6750 9425 50  0000 L CNN
F 1 "0.1uF" H 6750 9225 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 6763 9175 50  0001 C CNN
F 3 "~" H 6725 9325 50  0001 C CNN
	1    6725 9325
	1    0    0    -1  
$EndComp
Text GLabel 6175 9775 2    50   Input ~ 0
ADC_SCK
Text GLabel 6175 9675 2    50   Output ~ 0
ADC_DOUT
Wire Wire Line
	4300 10075 4700 10075
Connection ~ 4300 10075
Wire Wire Line
	4300 9875 4300 10075
Wire Wire Line
	4250 10075 4300 10075
Wire Wire Line
	2450 10075 3950 10075
Wire Wire Line
	4300 9325 4700 9325
Connection ~ 4300 9325
Wire Wire Line
	4300 9575 4300 9325
Wire Wire Line
	4250 9325 4300 9325
Wire Wire Line
	2450 10075 2450 9325
Wire Wire Line
	3850 9325 3950 9325
Wire Wire Line
	3150 10025 3150 10275
$Comp
L power:GND #PWR0107
U 1 1 5BFE469E
P 3150 10275
F 0 "#PWR0107" H 3150 10025 50  0001 C CNN
F 1 "GND" H 3155 10102 50  0000 C CNN
F 2 "" H 3150 10275 50  0001 C CNN
F 3 "" H 3150 10275 50  0001 C CNN
	1    3150 10275
	1    0    0    -1  
$EndComp
$Comp
L Device:C C11
U 1 1 5BFCEB31
P 4300 9725
F 0 "C11" H 4125 9825 50  0000 L CNN
F 1 "0.1uF" H 4075 9625 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 4338 9575 50  0001 C CNN
F 3 "~" H 4300 9725 50  0001 C CNN
	1    4300 9725
	1    0    0    -1  
$EndComp
$Comp
L Discrete_elemets:Strain_Gauge_Half_Bridge SG4
U 1 1 5BFA0261
P 3450 9325
F 0 "SG4" V 3350 9775 50  0000 R CNN
F 1 "GML623A" V 3250 9975 50  0000 R CNN
F 2 "" H 3450 9325 50  0001 C CNN
F 3 "" H 3450 9325 50  0001 C CNN
	1    3450 9325
	0    1    -1   0   
$EndComp
$Comp
L Discrete_elemets:Strain_Gauge_Half_Bridge SG2
U 1 1 5BFA00C1
P 2850 9325
F 0 "SG2" V 2800 9775 50  0000 R CNN
F 1 "GML623A" V 2700 9925 50  0000 R CNN
F 2 "" H 2850 9325 50  0001 C CNN
F 3 "" H 2850 9325 50  0001 C CNN
	1    2850 9325
	0    -1   1    0   
$EndComp
$Comp
L Discrete_elemets:Strain_Gauge_Half_Bridge SG3
U 1 1 5BF9FF79
P 3150 9625
F 0 "SG3" H 3250 9975 50  0000 C CNN
F 1 "GML623A" H 2950 9975 50  0000 C CNN
F 2 "" H 3150 9625 50  0001 C CNN
F 3 "" H 3150 9625 50  0001 C CNN
	1    3150 9625
	-1   0    0    1   
$EndComp
$Comp
L Discrete_elemets:Strain_Gauge_Half_Bridge SG1
U 1 1 5BF9FEB1
P 3150 9025
F 0 "SG1" H 3050 9375 50  0000 C CNN
F 1 "GML623A" H 3350 9375 50  0000 C CNN
F 2 "" H 3150 9025 50  0001 C CNN
F 3 "" H 3150 9025 50  0001 C CNN
	1    3150 9025
	1    0    0    -1  
$EndComp
$Comp
L Device:R R11
U 1 1 5C2E29F1
P 4100 10075
F 0 "R11" V 4000 10075 50  0000 C CNN
F 1 "100" V 4200 10075 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4030 10075 50  0001 C CNN
F 3 "~" H 4100 10075 50  0001 C CNN
	1    4100 10075
	0    1    1    0   
$EndComp
$Comp
L Device:R R10
U 1 1 5C2E27D0
P 4100 9325
F 0 "R10" V 4000 9325 50  0000 C CNN
F 1 "100" V 4200 9325 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4030 9325 50  0001 C CNN
F 3 "~" H 4100 9325 50  0001 C CNN
	1    4100 9325
	0    1    1    0   
$EndComp
$Comp
L Device:R R9
U 1 1 5C1DF91D
P 4825 8825
F 0 "R9" V 4725 8825 50  0000 C CNN
F 1 "15k" V 4925 8825 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4755 8825 50  0001 C CNN
F 3 "~" H 4825 8825 50  0001 C CNN
	1    4825 8825
	0    1    1    0   
$EndComp
$Comp
L Device:R R8
U 1 1 5C1CCE5D
P 5175 8625
F 0 "R8" H 5245 8671 50  0000 L CNN
F 1 "21k" H 5245 8580 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 5105 8625 50  0001 C CNN
F 3 "~" H 5175 8625 50  0001 C CNN
	1    5175 8625
	1    0    0    -1  
$EndComp
$Comp
L Device:C C10
U 1 1 5C1CC125
P 4325 8625
F 0 "C10" H 4350 8725 50  0000 L CNN
F 1 "0.1uF" H 4350 8525 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 4363 8475 50  0001 C CNN
F 3 "~" H 4325 8625 50  0001 C CNN
	1    4325 8625
	1    0    0    -1  
$EndComp
$Comp
L Device:C C9
U 1 1 5C1CC053
P 4075 8625
F 0 "C9" H 4100 8725 50  0000 L CNN
F 1 "10uF" H 4100 8525 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 4113 8475 50  0001 C CNN
F 3 "~" H 4075 8625 50  0001 C CNN
	1    4075 8625
	1    0    0    -1  
$EndComp
$Comp
L pspice:INDUCTOR L1
U 1 1 5C1CAF58
P 4825 8425
F 0 "L1" H 4825 8525 50  0000 C CNN
F 1 "3.3uH" H 4825 8375 50  0000 C CNN
F 2 "Inductor_SMD:L_0603_1608Metric" H 4825 8425 50  0001 C CNN
F 3 "~" H 4825 8425 50  0001 C CNN
	1    4825 8425
	1    0    0    -1  
$EndComp
$Comp
L Discrete_elemets:HX711 U2
U 1 1 5C1C9EDE
P 5475 9475
F 0 "U2" H 6025 9925 50  0000 C CNN
F 1 "HX711" H 5975 8975 50  0000 C CNN
F 2 "Package_SO:SOIC-16_3.9x9.9mm_P1.27mm" H 5475 9475 50  0001 C CNN
F 3 "" H 5475 9475 50  0001 C CNN
	1    5475 9475
	1    0    0    -1  
$EndComp
$Comp
L Transistor_BJT:MMBT3906 Q1
U 1 1 5C1C9951
P 5475 8525
F 0 "Q1" V 5625 8375 50  0000 C CNN
F 1 "MMBT3906" V 5712 8525 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23" H 5675 8450 50  0001 L CIN
F 3 "https://www.fairchildsemi.com/datasheets/2N/2N3906.pdf" H 5475 8525 50  0001 L CNN
	1    5475 8525
	0    -1   -1   0   
$EndComp
Text GLabel 1900 6200 0    50   Output ~ 0
Tara
Wire Wire Line
	2200 6200 1900 6200
Wire Wire Line
	2600 5775 2600 5700
Connection ~ 2600 5775
Wire Wire Line
	3650 5775 2600 5775
Wire Wire Line
	3650 6650 3650 5775
Wire Wire Line
	2600 5900 2600 5775
$Comp
L power:VCC #PWR03
U 1 1 5DEE22E2
P 2600 5700
F 0 "#PWR03" H 2600 5550 50  0001 C CNN
F 1 "VCC" H 2617 5873 50  0000 C CNN
F 2 "" H 2600 5700 50  0001 C CNN
F 3 "" H 2600 5700 50  0001 C CNN
	1    2600 5700
	1    0    0    -1  
$EndComp
Wire Wire Line
	1900 6950 2200 6950
Connection ~ 1900 6950
Wire Wire Line
	1600 6950 1900 6950
Wire Wire Line
	1900 6400 1600 6400
Connection ~ 1900 6400
Wire Wire Line
	1900 6400 1900 6650
Wire Wire Line
	1600 6400 1600 6650
Wire Wire Line
	2200 6400 1900 6400
Wire Wire Line
	2200 6650 2200 6500
Wire Wire Line
	2600 6700 2600 6925
Wire Wire Line
	3100 6950 2600 6950
Connection ~ 3100 6950
Connection ~ 2600 6950
Wire Wire Line
	3650 6950 3100 6950
Wire Wire Line
	3100 6300 3200 6300
Connection ~ 3100 6300
Wire Wire Line
	3100 6650 3100 6300
Wire Wire Line
	3000 6300 3100 6300
Wire Wire Line
	2200 6950 2600 6950
Connection ~ 2200 6950
$Comp
L Device:C C30
U 1 1 5CB46A4E
P 3650 6800
F 0 "C30" H 3675 6900 50  0000 L CNN
F 1 "0.1uF" H 3675 6700 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 3688 6650 50  0001 C CNN
F 3 "~" H 3650 6800 50  0001 C CNN
	1    3650 6800
	1    0    0    -1  
$EndComp
$Comp
L Device:C C27
U 1 1 5C310FEC
P 1900 6800
F 0 "C27" H 1925 6900 50  0000 L CNN
F 1 "27nF" H 1925 6700 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 1938 6650 50  0001 C CNN
F 3 "~" H 1900 6800 50  0001 C CNN
	1    1900 6800
	1    0    0    -1  
$EndComp
$Comp
L Discrete_elemets:C_Pad X1
U 1 1 5BF698C9
P 3400 6300
F 0 "X1" H 3400 6450 50  0000 C CNN
F 1 "On/Off" H 3400 6150 50  0000 C CNN
F 2 "" H 3400 5900 50  0001 C TNN
F 3 "" H 3400 5800 50  0001 C TNN
	1    3400 6300
	-1   0    0    -1  
$EndComp
Wire Wire Line
	2600 7050 2600 6950
$Comp
L power:GND #PWR0111
U 1 1 5C2D28EB
P 2600 7050
F 0 "#PWR0111" H 2600 6800 50  0001 C CNN
F 1 "GND" H 2605 6877 50  0000 C CNN
F 2 "" H 2600 7050 50  0001 C CNN
F 3 "" H 2600 7050 50  0001 C CNN
	1    2600 7050
	1    0    0    -1  
$EndComp
$Comp
L Device:C C29
U 1 1 5C27C59C
P 3100 6800
F 0 "C29" H 3150 6900 50  0000 L CNN
F 1 "18pF" H 3150 6700 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 3138 6650 50  0001 C CNN
F 3 "~" H 3100 6800 50  0001 C CNN
	1    3100 6800
	1    0    0    -1  
$EndComp
$Comp
L Device:C C26
U 1 1 5C27C4EC
P 1600 6800
F 0 "C26" H 1625 6900 50  0000 L CNN
F 1 "470nF" H 1625 6700 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 1638 6650 50  0001 C CNN
F 3 "~" H 1600 6800 50  0001 C CNN
	1    1600 6800
	1    0    0    -1  
$EndComp
$Comp
L Device:C C28
U 1 1 5C27C3DA
P 2200 6800
F 0 "C28" H 2225 6900 50  0000 L CNN
F 1 "100pF" H 2225 6700 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2238 6650 50  0001 C CNN
F 3 "~" H 2200 6800 50  0001 C CNN
	1    2200 6800
	1    0    0    -1  
$EndComp
$Comp
L Sensor_Touch:PCF8883 U4
U 1 1 5C248BBA
P 2600 6300
F 0 "U4" H 2400 6650 50  0000 R CNN
F 1 "PCF8883" H 2575 5950 50  0000 R CNN
F 2 "Package_SO:SOIC-8_3.9x4.9mm_P1.27mm" H 2500 5950 50  0001 R CNN
F 3 "http://www.nxp.com/docs/en/data-sheet/PCF8883.pdf" H 2600 6150 50  0001 C CNN
	1    2600 6300
	-1   0    0    -1  
$EndComp
Text GLabel 6525 6375 0    50   Input ~ 0
LED_B
Wire Wire Line
	7025 6575 7025 7050
Wire Wire Line
	7025 6175 7025 6275
Wire Wire Line
	6825 7125 6825 6875
$Comp
L power:GND #PWR07
U 1 1 5D5D3B9C
P 6825 7125
F 0 "#PWR07" H 6825 6875 50  0001 C CNN
F 1 "GND" H 6830 6952 50  0000 C CNN
F 2 "" H 6825 7125 50  0001 C CNN
F 3 "" H 6825 7125 50  0001 C CNN
	1    6825 7125
	1    0    0    -1  
$EndComp
Wire Wire Line
	7025 7050 7325 7050
Wire Wire Line
	7225 6950 7325 6950
Wire Wire Line
	7225 6875 7225 6950
Text GLabel 7325 7050 2    50   UnSpc ~ 0
Sink2
Text GLabel 7325 6950 2    50   UnSpc ~ 0
Sink1
$Comp
L Transistor_FET:BSS138 Q2
U 1 1 5D526A57
P 6725 6375
F 0 "Q2" H 6625 6525 50  0000 L CNN
F 1 "BSS138" H 6475 6175 50  0000 L CNN
F 2 "Package_TO_SOT_SMD:SOT-23" H 6925 6300 50  0001 L CIN
F 3 "https://www.fairchildsemi.com/datasheets/BS/BSS138.pdf" H 6725 6375 50  0001 L CNN
	1    6725 6375
	1    0    0    -1  
$EndComp
$Comp
L power:VSS #PWR04
U 1 1 5D3BE211
P 7025 5775
F 0 "#PWR04" H 7025 5625 50  0001 C CNN
F 1 "VSS" H 7042 5948 50  0000 C CNN
F 2 "" H 7025 5775 50  0001 C CNN
F 3 "" H 7025 5775 50  0001 C CNN
	1    7025 5775
	1    0    0    -1  
$EndComp
$Comp
L Discrete_elemets:IN-S126TASRGB D1
U 1 1 5BF909D8
P 7025 5975
F 0 "D1" V 7175 6325 50  0000 R CNN
F 1 "IN-S126TASRGB" V 7175 5875 50  0000 R CNN
F 2 "Discrete_elemets:LED_Inolux_IN-S126TASRGB_3x1.5mm_Horizontal" H 7025 6475 50  0001 C CNN
F 3 "http://www.inolux-corp.com/datasheet/SMDLED/RGB%20Side%20View/IN-S126TASRGB_V1.1.pdf" H 7025 5525 50  0001 C CNN
	1    7025 5975
	0    1    -1   0   
$EndComp
$Comp
L Device:R R13
U 1 1 5BF9179A
P 7025 6425
F 0 "R13" H 6900 6375 50  0000 C CNN
F 1 "2k" H 6900 6475 50  0000 C CNN
F 2 "Resistor_SMD:R_0603_1608Metric" V 6955 6425 50  0001 C CNN
F 3 "~" H 7025 6425 50  0001 C CNN
	1    7025 6425
	-1   0    0    1   
$EndComp
$Comp
L Device:R R12
U 1 1 5C227BDC
P 6825 6725
F 0 "R12" H 6700 6675 50  0000 C CNN
F 1 "470" H 6700 6775 50  0000 C CNN
F 2 "Resistor_SMD:R_0603_1608Metric" V 6755 6725 50  0001 C CNN
F 3 "~" H 6825 6725 50  0001 C CNN
	1    6825 6725
	-1   0    0    1   
$EndComp
$Comp
L Device:R R14
U 1 1 5C253AEF
P 7225 6725
F 0 "R14" H 7100 6675 50  0000 C CNN
F 1 "470" H 7100 6775 50  0000 C CNN
F 2 "Resistor_SMD:R_0603_1608Metric" V 7155 6725 50  0001 C CNN
F 3 "~" H 7225 6725 50  0001 C CNN
	1    7225 6725
	-1   0    0    1   
$EndComp
Wire Wire Line
	7225 6175 7225 6575
$EndSCHEMATC
